<?php

class strukturOrganisasiController extends Controller {
    public function index() {
        require_once '../app/Models/StrukturOrganisasi.php';
        $strukturModel = new StrukturOrganisasi();
        $struktur = $strukturModel->getAll();
        
        // Get the latest uploaded image from database
        $img = $strukturModel->getLatestImage();
        $struktur_gambar_url = '';
        
        if ($img && !empty($img['file_path'])) {
            // Build the full URL to the image
            $imagePath = '../public/' . ltrim($img['file_path'], '/');
            if (file_exists($imagePath)) {
                $struktur_gambar_url = BASE_URL . '/public/' . ltrim($img['file_path'], '/');
            }
        }
        
        $data = [
            'pageTitle' => 'Struktur Organisasi Kelurahan',
            'cssFiles' => [
                'css/style.css',     // Selalu dimuat (untuk reset, font dasar, dll)
                'css/components.css', // Untuk gaya header, footer, navigasi, dll.
                'css/strukturOrganisasi.css'
            ],
            'struktur' => $struktur,
            'struktur_gambar' => $struktur_gambar_url
        ];

        // Load the strukturOrganisasi view
        $this->view('public/components/header', $data);
        $this->view('public/profil/strukturOrganisasi', $data);
        $this->view('public/components/footer', $data);
    }
}