<?php
$slideshowDir = __DIR__ . '/../../../public/img/slideshow';
$slideshowUrl = BASE_URL . '/img/slideshow/';
$slideImages = array_filter(scandir($slideshowDir), function($f) {
    return preg_match('/\.(jpg|jpeg|png|webp)$/i', $f);
});
?>
<style>
.slide-img {
  position: absolute;
  left: 0; top: 0;
  width: 100%; height: 100%;
  object-fit: cover;
  aspect-ratio: 16/9;
  max-width: 1920px;
  max-height: 1080px;
  opacity: 0;
  transition: opacity 0.7s ease;
  z-index: 1;
}
.slide-img.active {
  opacity: 1;
  z-index: 2;
}
.slideshow-container { position: relative; }
.slide-btn { position: absolute; top: 50%; transform: translateY(-50%); background: rgba(0,0,0,0.3); color: #fff; border: none; font-size: 2em; padding: 0 12px; cursor: pointer; z-index: 10; }
.slide-btn.prev { left: 10px; }
.slide-btn.next { right: 10px; }
</style>
<section id="hero" class="hero-section">
  <h1>Selamat Datang di Website Resmi Kelurahan Lengkong Wetan</h1>
  <p>Melayani masyarakat dengan transparansi, profesionalisme, dan inovasi.</p>
  <div class="slideshow-container" style="position:relative;max-width:1920px;width:100%;aspect-ratio:16/9;height:auto;max-height:1080px;overflow:hidden;background:#e3e3e3;margin:auto;">
    <?php $i=0; foreach ($slideImages as $img): ?>
      <img src="<?= $slideshowUrl . $img ?>" class="slide-img<?= $i==0?' active':'' ?>" alt="Slideshow">
    <?php $i++; endforeach; ?>
    <button class="slide-btn prev" onclick="plusSlides(-1)">&#10094;</button>
    <button class="slide-btn next" onclick="plusSlides(1)">&#10095;</button>
  </div>
</section>
<script>
let slideIndex = 0;
const slides = document.getElementsByClassName('slide-img');
function showSlide(n) {
  for (let i = 0; i < slides.length; i++) slides[i].classList.remove('active');
  slides[n].classList.add('active');
}
function plusSlides(n) {
  slideIndex += n;
  if (slideIndex >= slides.length) slideIndex = 0;
  if (slideIndex < 0) slideIndex = slides.length - 1;
  showSlide(slideIndex);
}
setInterval(()=>plusSlides(1), 4000);
</script>
    <section class="img-desc-section">
    <img src="<?= BASE_URL ?>/img/foto_beranda/draftLurah.png" alt="Gambar Kiri" class="img-kiri">
        <div class="desc-kanan">
            <h2>Sambutan Lurah</h2>
            <p>Selamat datang di website resmi Kelurahan kami. Kami berkomitmen untuk memberikan pelayanan terbaik kepada masyarakat dengan transparansi, profesionalisme, dan inovasi. Melalui platform ini, kami berharap dapat menjangkau lebih banyak warga dan mempermudah akses informasi serta layanan publik.</p>
            <p>Website ini dirancang untuk memberikan kemudahan dalam mengakses berbagai informasi terkait kelurahan, termasuk layanan, berita terkini, dan pengumuman penting.</p>
            <p>Terima kasih atas kepercayaan Anda kepada kami. Mari bersama-sama membangun kelurahan yang lebih baik.</p>
            <p>Hormat kami,</p>
        </div>
    </section>

    <section id="layanan-cepat" class="layanan-cepat-section" aria-labelledby="layanan-cepat-title" tabindex="0">
      <div class="confetti"></div>
      <h2 id="layanan-cepat-title" class="section-title">Layanan Cepat</h2>
      <div class="layanan-grid">
        <a href="<?=BASE_URL?>/pelayanan/kk" class="layanan-card-link">
          <article class="layanan-card" tabindex="0" role="button" aria-label="Layanan Pengurusan Kartu Keluarga">
            <span class="material-icons layanan-icon" aria-hidden="true">badge</span>
            <h3 class="layanan-title">Kartu Keluarga</h3>
            <p class="layanan-description">Proses cepat pembuatan dan pengurusan Kartu Keluarga tanpa ribet.</p>
          </article>
        </a>
        <a href="<?=BASE_URL?>/pelayanan/ktp" class="layanan-card-link">
          <article class="layanan-card" tabindex="0" role="button" aria-label="Layanan Pembuatan dan Perpanjangan KTP">
            <span class="material-icons layanan-icon" aria-hidden="true">badge</span>
            <h3 class="layanan-title">KTP</h3>
            <p class="layanan-description">Prioritas layanan pembuatan dan perpanjangan KTP dengan proses efisien.</p>
          </article>
        </a>
        <a href="<?=BASE_URL?>/pelayanan/kia" class="layanan-card-link">
          <article class="layanan-card" tabindex="0" role="button" aria-label="Layanan KIA">
            <span class="material-icons layanan-icon" aria-hidden="true">badge</span>
            <h3 class="layanan-title">KIA</h3>
            <p class="layanan-description">Layanan pembuatan Kartu Identitas Anak (KIA) untuk anak di bawah 17 tahun.</p>
          </article>
        </a>
        <a href="<?=BASE_URL?>/pelayanan/akta-lahir" class="layanan-card-link">
          <article class="layanan-card" tabindex="0" role="button" aria-label="Layanan Akta Lahir">
            <span class="material-icons layanan-icon" aria-hidden="true">business_center</span>
            <h3 class="layanan-title">Akta Lahir</h3>
            <p class="layanan-description">Dirancang untuk mempermudah mendapatkan akta kelahiran dengan prosedur yang efisien </p>
          </article>
        </a>
      </div>
    </section>
