<style>
  .navbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 32px;
    background: linear-gradient(90deg, #e0f2fe 0%, #c7d2fe 100%); /* biru muda */
    color: #222;
    position: relative;
    z-index: 100;
    min-height: 64px;
    border-bottom: 1px solid #e5e7eb;
  }
  .brand {
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 12px;
    font-weight: 900;
    font-size: 1.1rem;
    color: #222;
    letter-spacing: 0.5px;
    user-select: none;
    line-height: 1.1;
    margin-right: 32px;
  }
  .brand-logo {
    height: 48px;
    width: auto;
    margin-bottom: 0;
    margin-right: 10px;
  }
  .brand-title {
    font-size: 1.1rem;
    font-weight: 900;
    color: #222;
    margin-bottom: 0;
    margin-top: 0;
    line-height: 1.1;
  }
  .brand-subtitle {
    font-size: 0.95rem;
    font-weight: 700;
    color: #222;
    margin-top: 0;
    margin-bottom: 0;
    line-height: 1.1;
  }
  .nav-list {
    display: flex;
    list-style: none;
    gap: 18px;
    margin: 0;
    padding: 0;
    align-items: center;
  }
  .nav-link, .dropdown-link {
    color: #6366f1;
    text-decoration: none;
    font-weight: 600;
    padding: 8px 14px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 1.05rem;
    transition: background 0.2s, color 0.2s;
  }
  .nav-link .material-icons, .dropdown-link .material-icons {
    font-size: 1.2em;
    color: #6366f1;
    vertical-align: middle;
    margin-bottom: 2px;
  }
  .nav-link:hover, .dropdown-link:hover, .nav-link:focus, .dropdown-link:focus {
    background: #e0e7ff;
    color: #3730a3;
    outline: none;
  }
  .nav-link:hover .material-icons, .dropdown-link:hover .material-icons {
    color: #3730a3;
  }
  .nav-dropdown {
    position: relative;
  }
  .dropdown-menu {
    display: none;
    position: absolute;
    left: 0;
    top: 100%;
    min-width: 180px;
    background: #fff;
    box-shadow: 0 4px 16px rgba(44,62,80,0.08);
    border-radius: 8px;
    padding: 8px 0;
    z-index: 1000;
    transition: opacity 0.2s, visibility 0.2s;
    opacity: 0;
    visibility: hidden;
  }
  .nav-dropdown:hover > .dropdown-menu,
  .nav-dropdown:focus-within > .dropdown-menu {
    display: block;
    opacity: 1;
    visibility: visible;
  }
  .dropdown-menu li {
    width: 100%;
  }
  .dropdown-link {
    display: flex;
    width: 100%;
    color: #6366f1;
    padding: 10px 18px;
    background: none;
    border: none;
    text-align: left;
    cursor: pointer;
    gap: 6px;
  }
  .dropdown-link:hover, .dropdown-link:focus {
    background: #e0e7ff;
    color: #3730a3;
  }
  .menu-toggle {
    display: none;
  }
  @media (max-width: 900px) {
    .navbar {
      padding: 10px 20px;
      background: rgba(255,255,255,0.7);
      min-height: 56px;
    }
    .brand {
      flex-direction: row;
      align-items: center;
      font-size: 1rem;
      gap: 8px;
      margin-right: 0;
    }
    .brand-title, .brand-subtitle {
      font-size: 1rem;
      font-weight: 700;
    }
    .nav-list {
      display: none;
      flex-direction: column;
      position: absolute;
      top: 60px;
      left: 0;
      width: 100vw;
      background: rgba(255,255,255,0.98);
      box-shadow: 0 4px 16px rgba(44,62,80,0.08);
      padding: 10px 0;
      z-index: 1000;
    }
    .nav-list.show {
      display: flex;
    }
    .menu-toggle {
      display: inline;
      margin-left: auto;
      background: none;
      border: none;
      color: #222;
      font-size: 24px;
      cursor: pointer;
    }
    .nav-dropdown .dropdown-menu {
      position: static;
      box-shadow: none;
      background: none;
      opacity: 1;
      visibility: visible;
      display: none;
      padding: 0;
      min-width: 0;
    }
    .nav-dropdown.open .dropdown-menu {
      display: block;
    }
  }
</style>

<nav class="navbar" role="navigation" aria-label="Navigasi utama">
  <div class="brand">
    <img src="<?=BASE_URL?>/img/foto_beranda/Lambang_Kota_Tangerang_Selatan.png" alt="Logo Kelurahan" class="brand-logo" />
    <div>
      <div class="brand-title">KELURAHAN LENGKONG WETAN</div>
      <div class="brand-subtitle">SERPONG TANGERANG SELATAN</div>
    </div>
  </div>
  <ul class="nav-list" id="main-nav">
    <li><a href="<?=BASE_URL?>/" class="nav-link" tabindex="0"><span class="material-icons">home</span>Beranda</a></li>
    <li class="nav-dropdown" tabindex="0">
      <a href="#" class="nav-link" aria-haspopup="true" aria-expanded="false" tabindex="0" onclick="toggleDropdown(event)"><span class="material-icons">person</span>Profile <span class="material-icons" style="font-size:1em;vertical-align:middle;">expand_more</span></a>
      <ul class="dropdown-menu" aria-label="Submenu Profil">
        <li><a href="<?=BASE_URL?>/sejarah" class="dropdown-link" tabindex="0"><span class="material-icons">history_edu</span>Sejarah</a></li>
        <li><a href="<?=BASE_URL?>/visimisi" class="dropdown-link" tabindex="0"><span class="material-icons">flag</span>Visi - Misi</a></li>
        <li><a href="<?=BASE_URL?>/strukturOrganisasi" class="dropdown-link" tabindex="0"><span class="material-icons">account_tree</span>Struktur Organisasi</a></li>
      </ul>
    </li>
    <li class="nav-dropdown" tabindex="0">
      <a href="#" class="nav-link" aria-haspopup="true" aria-expanded="false" tabindex="0" onclick="toggleDropdown(event)"><span class="material-icons">apartment</span>Fasilitas <span class="material-icons" style="font-size:1em;vertical-align:middle;">expand_more</span></a>
      <ul class="dropdown-menu" aria-label="Submenu Fasilitas">
        <li><a href="<?=BASE_URL?>/fasilitas/pendidikan" class="dropdown-link" tabindex="0"><span class="material-icons">school</span>Pendidikan</a></li>
        <li><a href="<?=BASE_URL?>/fasilitas/kesehatan" class="dropdown-link" tabindex="0"><span class="material-icons">local_hospital</span>Kesehatan</a></li>
        <li><a href="<?=BASE_URL?>/fasilitas/ibadah" class="dropdown-link" tabindex="0"><span class="material-icons">mosque</span>Ibadah</a></li>
        <li><a href="<?=BASE_URL?>/fasilitas/balaiwarga" class="dropdown-link" tabindex="0"><span class="material-icons">groups</span>Balai Warga</a></li>
      </ul>
    </li>
    <li><a href="<?=BASE_URL?>/pelayanan" class="nav-link" tabindex="0"><span class="material-icons">headset_mic</span>Pelayanan</a></li>
    <li><a href="<?=BASE_URL?>/berita" class="nav-link" tabindex="0"><span class="material-icons">apartment</span>Berita</a></li>
  </ul>
  <button class="menu-toggle" aria-label="Buka menu" aria-expanded="false" aria-controls="main-nav" tabindex="0" onclick="toggleMenu()">
    <span class="material-icons">menu</span>
  </button>
</nav>
<script>
// Toggle menu mobile
function toggleMenu() {
  const nav = document.querySelector('.nav-list');
  nav.classList.toggle('show');
  const btn = document.querySelector('.menu-toggle');
  btn.setAttribute('aria-expanded', nav.classList.contains('show'));
}
// Dropdown mobile: klik untuk buka/tutup
function toggleDropdown(e) {
  if(window.innerWidth <= 900) {
    e.preventDefault();
    const parent = e.target.closest('.nav-dropdown');
    parent.classList.toggle('open');
    // Tutup dropdown lain
    document.querySelectorAll('.nav-dropdown').forEach(function(item){
      if(item !== parent) item.classList.remove('open');
    });
  }
}
// Tutup menu saat klik di luar
window.addEventListener('click', function(e) {
  const nav = document.querySelector('.nav-list');
  const btn = document.querySelector('.menu-toggle');
  if (!nav.contains(e.target) && !btn.contains(e.target)) {
    nav.classList.remove('show');
    btn.setAttribute('aria-expanded', 'false');
    document.querySelectorAll('.nav-dropdown').forEach(function(item){
      item.classList.remove('open');
    });
  }
});
// Keyboard accessibility: ESC untuk tutup menu
window.addEventListener('keydown', function(e) {
  if(e.key === 'Escape') {
    document.querySelector('.nav-list').classList.remove('show');
    document.querySelectorAll('.nav-dropdown').forEach(function(item){
      item.classList.remove('open');
    });
  }
});
</script>
