# 🚀 QUICK START GUIDE - SISTEM WAREHOUSE v2.0

Panduan cepat setup dan menggunakan fitur-fitur baru sistem warehouse.

---

## ⚡ SETUP CEPAT (5 Menit)

### Step 1: Setup Database (1 menit)
```sql
-- Buka phpMyAdmin → warehouse database
-- Jalankan 2 script SQL:

1. Buka file setup_retur_table.sql
   - Copy semua kode
   - Paste ke query builder phpMyAdmin
   - Click RUN

2. Buka file setup_log_table.sql
   - Copy semua kode
   - Paste ke query builder phpMyAdmin
   - Click RUN
```

### Step 2: Test Login (1 menit)
```
URL: http://localhost/warehouse/
Username: admin (atau sesuai data Anda)
Password: (sesuai database)
```

### Step 3: Explore Features (3 menit)
```
Masuk sebagai Admin → Klik tombol di Dashboard
- 📊 Grafik Paket
- ⏰ Monitoring SLA
- 📋 Log Aktivitas
- 📦 Persetujuan Retur
```

---

## 📌 FITUR BARU - CHEAT SHEET

### 1️⃣ Grafik Harian (chart.php)
**Akses:** Dashboard Admin → 📊 Lihat Grafik Paket

**Yang bisa dilihat:**
- Jumlah paket masuk per hari (7 hari terakhir)
- Jumlah paket keluar/dikirim per hari (7 hari terakhir)
- Trend perbandingan masuk vs keluar

**Teknologi:** Chart.js (auto-update)

---

### 2️⃣ Monitoring SLA (sla_checker.php)
**Akses:** Dashboard Admin → ⏰ Monitoring SLA

**Yang bisa dilakukan:**
- Lihat status SLA setiap paket (Tepat Waktu / Terlambat)
- Filter: Semua, Terlambat Saja, Tepat Waktu
- Lihat berapa jam/hari waktu tersisa
- Export view untuk laporan

**Warna Status:**
- 🟢 Hijau = Tepat Waktu
- 🔴 Merah = Terlambat

---

### 3️⃣ Log Aktivitas (log_aktivitas.php)
**Akses:** Dashboard Admin → 📋 Log Aktivitas

**Catatan aktivitas:**
- Input Paket (oleh petugas masuk)
- Pengiriman Paket (oleh petugas keluar)
- Perubahan Status (otomatis)
- Persetujuan Retur (oleh admin)

**Fitur:**
- Search berdasarkan nomor resi
- Filter berdasarkan jenis aktivitas
- Tampil timestamp akurat
- Statistik aktivitas

---

### 4️⃣ Persetujuan Retur (retur_approval.php)
**Akses:** Dashboard Admin → 📦 Persetujuan Retur

**3 Bagian:**

**A. Form Pengajuan (untuk petugas keluar)**
- Pilih paket yang sudah dikirim
- Isi alasan retur
- Click "Ajukan Retur"

**B. Daftar Retur Menunggu (untuk admin)**
- Lihat retur yang belum di-approve
- 2 tombol: Setujui / Tolak
- Konfirmasi sebelum submit

**C. Riwayat Retur**
- History semua retur yang sudah di-process
- Filter: Disetujui / Ditolak

---

## 📊 DASHBOARD FLOW

### Admin Dashboard
```
LOGIN
  ↓
DASHBOARD ADMIN
  ├─ 📊 Grafik Paket → 3 chart harian
  ├─ ⏰ Monitoring SLA → Status SLA & terlambat
  ├─ 📋 Log Aktivitas → Riwayat perubahan
  ├─ 📦 Persetujuan Retur → Approve/tolak retur
  └─ 📊 Monitoring Table → 25 paket terbaru
```

### Petugas Masuk Dashboard
```
LOGIN (role: petugas_masuk)
  ↓
DASHBOARD MASUK
  ├─ ➕ Input Paket Masuk Baru
  └─ 📦 Daftar Paket Masuk (25 terbaru)
```

### Petugas Keluar Dashboard
```
LOGIN (role: petugas_keluar)
  ↓
DASHBOARD KELUAR
  ├─ Lihat paket siap dikirim
  ├─ Status SLA (Tepat Waktu / Menunggu / Terlambat)
  └─ ✈️ Tombol Kirim (jika ready)
```

---

## 🔍 TROUBLESHOOTING

### Error: "Table doesn't exist"
```
Solusi: Jalankan setup_retur_table.sql dan setup_log_table.sql
        di phpMyAdmin
```

### Error: "Call to undefined function insertLog()"
```
Solusi: Pastikan file log_helper.php sudah ada di folder warehouse
        Include: include "log_helper.php";
```

### Grafik tidak tampil
```
Solusi: Cek internet (Chart.js butuh CDN)
        Buka Console Browser (F12) untuk cek error
```

### Log tidak terekam
```
Solusi: Pastikan folder warehouse punya write permission
        Check log_aktivitas table sudah ada di database
```

---

## 📱 RESPONSIVE DESIGN

✅ Semua fitur support:
- Desktop (1920px+)
- Tablet (768px+)
- Mobile (360px+)

Bootstrap 5.3 sudah terintegrasi di semua file.

---

## 📈 CONTOH USAGE SCENARIO

### Scenario: Order masuk → Proses → Pengiriman

```
1. PETUGAS MASUK
   - Login → Dashboard Masuk
   - Click ➕ Input Paket Masuk Baru
   - Isi form (resi, nama, barang, dll)
   - Submit
   ✓ Log otomatis tercatat: "Input Paket"

2. ADMIN MONITORING
   - Login → Dashboard Admin
   - Click 📊 Grafik → Lihat paket masuk hari ini
   - Click ⏰ Monitoring SLA → Cek status
   - Click 📋 Log → Lihat aktivitas baru

3. PETUGAS KELUAR
   - Login → Dashboard Keluar
   - Lihat paket status "Menunggu"
   - Cek status SLA (Tepat Waktu / Menunggu)
   - Click ✈️ Kirim jika ready
   ✓ Log otomatis tercatat: "Pengiriman Paket"

4. JIKA ADA MASALAH (Retur)
   - Petugas Keluar → Input form retur
   - Alasan & paket
   - Submit
   ✓ Log tercatat: "Permintaan Retur"
   
   - Admin → Click Retur
   - Lihat daftar retur pending
   - Review & Click Setujui/Tolak
   ✓ Log tercatat: "Retur Disetujui/Ditolak"
```

---

## 🔄 DATA FLOW DIAGRAM

```
         INPUT PAKET
              ↓
    ┌─────────────────────┐
    │   TABEL PAKET       │
    │ Status: Menunggu    │
    └─────────────────────┘
              ↓
    MONITORING ADMIN
    - SLA Check
    - Grafik tracking
    - Log recording
              ↓
    READY UNTUK KIRIM
    (Status berubah ke Dikirim)
              ↓
    ┌─────────────────────┐
    │ Paket Terkirim OK?  │
    ├─────────────────────┤
    │ YES │     NO (Retur)│
    └──┬──┴──────┬────────┘
       │         │
       ↓         ↓
    SELESAI   RETUR APPROVAL
               ↓
            ADMIN APPROVE
               ↓
            SELESAI
```

---

## 💾 FILE PENTING

```
warehouse/
├── chart.php                  ← Grafik
├── sla_checker.php           ← Monitoring SLA
├── log_aktivitas.php         ← Log viewer
├── log_helper.php            ← Log helper function
├── retur_approval.php        ← Retur management
├── setup_retur_table.sql     ← Retur table script
├── setup_log_table.sql       ← Log table script
├── dashboard_admin.php       ← Admin dashboard (updated)
├── input_paket.php           ← Input form (updated)
├── kirim.php                 ← Pengiriman (updated)
├── CHANGELOG.md              ← Dokumentasi lengkap
└── README_QUICKSTART.md      ← File ini
```

---

## ✅ CHECKLIST SEBELUM PRODUCTION

- [ ] Database sudah backup
- [ ] setup_retur_table.sql sudah jalan
- [ ] setup_log_table.sql sudah jalan
- [ ] Login berjalan normal
- [ ] Bisa input paket (log tercatat)
- [ ] Bisa kirim paket (log tercatat)
- [ ] Dashboard admin menampilkan 4 tombol baru
- [ ] Grafik bisa dibuka (butuh internet)
- [ ] SLA monitoring berjalan
- [ ] Log aktivitas menampilkan data

---

## 🎓 UNTUK PRESENTASI / LAPORAN

**Highlight Features:**
1. **Grafik real-time** - Visualisasi data harian dengan Chart.js
2. **SLA Tracking** - Otomatis deteksi paket terlambat
3. **Audit Log** - Riwayat lengkap setiap perubahan
4. **Retur Management** - Proses approval retur terstruktur
5. **Modern UI** - Bootstrap 5.3 responsive design

**Demo Path:**
```
1. Login Admin
2. Show Grafik (5 detik)
3. Show SLA Monitoring (cari paket terlambat)
4. Show Log Aktivitas (search aktivitas)
5. Show Retur (ajukan + approve)
6. Highlight dashboard yang baru
```

---

**Dokumentasi dibuat: 19 Desember 2025**
**Last Updated: v2.0**
**Status: Ready to Deploy**
