<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Petugas Barang Keluar</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #f5f5f5; padding: 20px; }
.container-main { max-width: 1200px; margin: 0 auto; }
h2 { color: #333; margin-bottom: 30px; }
th { background: #667eea; color: white; }
.btn-kirim { padding: 5px 12px; font-size: 13px; }
.btn-menunggu { padding: 5px 12px; font-size: 13px; }
</style>
</head>
<body>

<div class="container-main">
<h2>📤 Dashboard Petugas – Barang Keluar</h2>

<div class="card">
<div class="card-header" style="background: #667eea; color: white;">
<h5 class="mb-0">📦 Paket Siap Dikirim (Terbaru 25)</h5>
</div>
<div class="card-body">
<div class="table-responsive">
<table class="table table-striped">
<tr>
<th>Resi</th>
<th>Barang</th>
<th>Tipe Pengiriman</th>
<th>Rak</th>
<th>Status SLA</th>
<th>Aksi</th>
</tr>

<?php
$q = mysqli_query($koneksi,"
SELECT paket.*, rak.nama_rak
FROM paket 
LEFT JOIN rak ON paket.id_rak=rak.id_rak
WHERE paket.status_pengiriman='Menunggu'
ORDER BY paket.id_paket DESC
LIMIT 25
");

while ($d = mysqli_fetch_array($q)) {

    // Hitung waktu sejak paket masuk
    $waktu_masuk = new DateTime($d['waktu_masuk']);
    $sekarang = new DateTime();
    $jam_berlalu = $sekarang->getTimestamp() - $waktu_masuk->getTimestamp();
    $jam = $jam_berlalu / 3600;
    
    $boleh = false;
    $status_sla = '';
    $status_color = 'warning';
    
    if ($d['tipe_pengiriman'] == 'Instan' && $jam <= 3) {
        $boleh = true;
        $status_sla = 'Tepat Waktu';
        $status_color = 'success';
    } elseif ($d['tipe_pengiriman'] == 'Instan' && $jam > 3) {
        $status_sla = 'TERLAMBAT';
        $status_color = 'danger';
    } elseif ($d['tipe_pengiriman'] == 'Same Day') {
        $boleh = true;
        $status_sla = 'Tepat Waktu';
        $status_color = 'success';
    } elseif ($d['tipe_pengiriman'] == 'Cargo' && $jam >= 72) {
        $boleh = true;
        $status_sla = 'Tepat Waktu';
        $status_color = 'success';
    } else {
        $status_sla = 'Menunggu';
        $status_color = 'warning';
    }
?>
<tr>
<td><strong><?php echo $d['no_resi']; ?></strong></td>
<td><?php echo $d['nama_barang']; ?></td>
<td><?php echo $d['tipe_pengiriman']; ?></td>
<td><?php echo $d['nama_rak'] ?? '-'; ?></td>
<td><span class="badge bg-<?php echo $status_color; ?>"><?php echo $status_sla; ?></span></td>
<td>
<?php if($boleh){ ?>
<a href="kirim.php?id=<?php echo $d['id_paket']; ?>" class="btn btn-success btn-sm btn-kirim">✈️ Kirim</a>
<?php } else { ?>
<button class="btn btn-secondary btn-sm btn-menunggu" disabled>⏳ Menunggu</button>
<?php } ?>
</td>
</tr>
<?php } ?>
</table>
</div>
</div>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
